/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process.diagram;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class VWGenericSubPropertyPanel
extends JPanel
implements DocumentListener,
IVWPropertyChangeSource {
    protected VWAuthPropertyData m_authPropertyData = null;
    protected VWMapNode m_selectedMapNode = null;
    protected Vector m_changedItems = null;
    protected Vector m_controls;
    protected JTextField m_nameTextField;
    protected JTextArea m_descriptionTextArea;

    public VWGenericSubPropertyPanel(VWAuthPropertyData authPropertyData, String stepType) {
        this.m_authPropertyData = authPropertyData;
        this.m_controls = new Vector();
        this.createControls();
        this.setEnabled(false);
    }

    public void setEnabled(boolean bEnable) {
        super.setEnabled(bEnable);
        if (this.m_controls == null) {
            return;
        }
        for (int i = 0; i < this.m_controls.size(); ++i) {
            JComponent component = (JComponent)this.m_controls.elementAt(i);
            if (component == null) continue;
            if (component instanceof JTextArea) {
                JTextArea textArea = (JTextArea)component;
                textArea.setEditable(bEnable);
                if (bEnable) {
                    textArea.setBackground(SystemColor.text);
                    continue;
                }
                textArea.setBackground(this.getBackground());
                continue;
            }
            component.setEnabled(bEnable);
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 501);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedStep(VWMapNode vwMapNode) {
        if (vwMapNode == null || vwMapNode == this.m_selectedMapNode) {
            return;
        }
        this.m_selectedMapNode = vwMapNode;
        try {
            try {
                this.m_nameTextField.getDocument().removeDocumentListener(this);
                this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                this.m_nameTextField.setText("");
                this.m_descriptionTextArea.setText("");
                if (this.m_selectedMapNode != null) {
                    this.m_nameTextField.setText(this.getDisplayName());
                    this.m_descriptionTextArea.setText(this.m_selectedMapNode.getDescription());
                }
                this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var4_3 = null;
                this.m_nameTextField.getDocument().addDocumentListener(this);
                this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            }
            Object var4_2 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            throw throwable;
        }
    }

    protected String getDisplayName() {
        if (this.m_selectedMapNode != null) {
            return VWPropertyMenuItem.getDisplayName(this.m_selectedMapNode);
        }
        return null;
    }

    protected void displayHelpPage() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh140.htm");
    }

    protected void releaseReferences() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        this.m_authPropertyData = null;
        this.m_selectedMapNode = null;
        this.removeAll();
    }

    protected void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.getNamePanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this.getDescriptionPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getNamePanel() {
        try {
            VWToolbarBorder stepNameBorder = new VWToolbarBorder(VWResource.s_stepNameStr);
            JPanel childPanel = stepNameBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_nameTextField = new JTextField("", 15);
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_controls.addElement(this.m_nameTextField);
            childPanel.add((Component)this.m_nameTextField, "First");
            return stepNameBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel getDescriptionPanel() {
        try {
            VWToolbarBorder descriptionBorder = new VWToolbarBorder(VWResource.s_descriptionStr);
            JPanel childPanel = descriptionBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setName("m_descriptionTextArea_VWDiagramProcessPropertyPanel");
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(3);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_controls.addElement(this.m_descriptionTextArea);
            childPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            return descriptionBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void handleDocumentEvent(DocumentEvent event) {
        if (this.m_selectedMapNode == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        } else if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
            this.m_selectedMapNode.setDescription(this.m_descriptionTextArea.getText());
            this.m_authPropertyData.setDirty();
        }
    }

    protected void updateName() {
        try {
            if (this.m_selectedMapNode != null && this.m_nameTextField != null) {
                String name = this.m_nameTextField.getText();
                String blankName = VWPropertyMenuItem.getBlankName(this.m_selectedMapNode);
                if ((name.length() == 0 || name.equals(blankName)) && this.m_selectedMapNode.getName() == null) {
                    return;
                }
                this.m_selectedMapNode.setName(name);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_selectedMapNode);
                this.notifyPropertyChange();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

